/*
 modul NodeMCU ESP32 S
board Ai Thinker 
display TFT 1.8 ST7735 conectat astfel
 TFT_MISO 19
 TFT_MOSI 23
 TFT_SCLK 18
 TFT_CS   5  // Chip select control pin
 TFT_DC    2  // Data Command control pin
 TFT_RST   4  
libraria TFT eSPI in care s-a modificat
fila User Setup
libraria WebSeial
genereaza Hot Spot cu 
  IP 192.168.4.1
  dupa incarcare pe TFT 
  apare adresa IP 192.169.4.1
  Se dexchide pe Android Chrome
  Se introdice 192.168.4.1/webserial
  apare pagina web
  tot ce se editeaza  pe telefon apare pe TFT
  
*/

#include <Arduino.h>
#include <WiFi.h>
#include <AsyncTCP.h>
#include <ESPAsyncWebServer.h>
#include <WebSerial.h>

AsyncWebServer server(80);

const char* ssid = "ESP32-HotSpot"; 
const char* password = "12345678"; 

#include <TFT_eSPI.h> // Graphics and font library for ST7735 driver chip
#include <SPI.h>
TFT_eSPI tft = TFT_eSPI();  // Invoke library, pins defined in User_Setup.h
#define TFT_GREY 0xBDF7

void recvMsg(uint8_t *data, size_t len){
  WebSerial.println("Received Data...");
  String d = "";
  for(int i=0; i < len; i++){
    d += char(data[i]);
    Serial.println(d);
    //tft.setTextWrap(false);
  //tft.fillScreen(ST7735_BLACK);
  //tft.fillScreen(TFT_GREY);
  tft.fillScreen(TFT_BLACK);
  tft.setCursor(0, 0);
  //tft.setTextColor(ST7735_YELLOW);
  //tft.setTextColor(TFT_GREEN, TFT_GREY);
  tft.setTextColor(TFT_GREEN, TFT_BLACK);
  tft.setTextSize(2);
  tft.print("Primit=");
  tft.print(d);
  Serial.print(d);
  }
  WebSerial.println(d);
}

void setup() {
  Serial.begin(115200);
    WiFi.softAP(ssid, password);

    IPAddress IP = WiFi.softAPIP();
    Serial.print("AP IP address: ");
    Serial.println(IP);
    // WebSerial is accessible at "<IP Address>/webserial" in browser
    WebSerial.begin(&server);
    /* Attach Message Callback */
    WebSerial.msgCallback(recvMsg);
    server.begin();

    
   tft.init();   // initialize a ST7735S chip,
   tft.setRotation(0);
   //tft.fillScreen(ST7735_BLACK);
   //tft.fillScreen(TFT_GREY);
   tft.fillScreen(TFT_BLACK);
  tft.setCursor(0, 0);
  //tft.setTextColor(ST7735_WHITE);
  //tft.setTextColor(TFT_GREEN, TFT_GREY); 
  tft.setTextColor(TFT_GREEN, TFT_BLACK);
  
  tft.setTextSize(2);
  tft.println("ST7735 webserial IP=");
  tft.print(IP);
  delay(5000);
    
}


void loop() {
  
    }
